'use strict';

/* --------------------------------------------------------------
 sortable.js 2019-07-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Content manager controller to implement sortable functionality for pages.
 */
gx.controllers.module('sortable', [jse.source + '/vendor/jquery-ui-dist/jquery-ui.min.css', jse.source + '/vendor/jquery-ui-dist/jquery-ui.js'], function () {
    'use strict';

    var SORTING_ID_ATTRIBUTE = 'data-sorting-id';

    var SAVE_SORTING_REQUEST_URL = 'admin.php?do=ContentManagerPagesAjax/SavePagesSorting';
    var SAVE_SORTING_REQUEST_METHOD = 'POST';

    var $errorModal = $('.sorting-failed.modal');
    var $emptyListTemplate = $('#empty-list');
    var $lists = $('#pages_main, #pages_secondary, #pages_info, #pages_info_box');

    var sortableOptions = {
        items: 'li.content-manager-element',
        axis: 'y',
        cursor: 'move',
        handle: '.sort-handle',
        containment: '#main-content',
        connectWith: '.content-manager-container',
        placeholder: 'col-md-12 content-manager-element sort-placeholder'
    };

    function init(done) {
        $lists.sortable(sortableOptions).on('sortupdate', saveSorting).disableSelection();

        done();
    }

    function handleError() {
        $errorModal.modal('show');
    }

    function handleResponses() {
        for (var _len = arguments.length, responses = Array(_len), _key = 0; _key < _len; _key++) {
            responses[_key] = arguments[_key];
        }

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = responses[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var response = _step.value;

                var parsed = response[0];

                if (parsed[0] !== 'success') {
                    handleError();
                }
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }
    }

    function saveSorting(event, ui) {
        var _$;

        if (!ui.item.parent().is('ul')) {
            $lists.sortable('cancel');
        }

        var requests = [];

        function performRequest(index, element) {
            var $list = $(element);

            var ajaxOptions = {
                url: SAVE_SORTING_REQUEST_URL,
                method: SAVE_SORTING_REQUEST_METHOD,
                dataType: 'json',
                data: {
                    position: $list.prop('id'),
                    pages: $list.sortable('toArray', { attribute: SORTING_ID_ATTRIBUTE })
                }
            };

            var request = $.ajax(ajaxOptions);

            requests.push(request);

            updateEntryCount($list);
        }

        if (!ui.item.parents('.ui-sortable').is(this)) {
            return;
        }

        $lists.each(performRequest);

        (_$ = $).when.apply(_$, requests).then(handleResponses).fail(handleError);
    }

    function updateEntryCount($list) {
        var $container = $list.find('.content-manager-elements-list');
        var $entries = $container.find('.content-manager-element');
        var $emptyListElement = $entries.not('[' + SORTING_ID_ATTRIBUTE + ']');

        if ($entries.length - $emptyListElement.length === 0) {
            $container.empty().append($emptyListTemplate.clone().html());
        } else {
            $emptyListElement.remove();
        }
    }

    return { init: init };
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
